%%%%%%%%%%%%%%%%%%%%%%%%
% convergence of the PPPA

% You need to install the SPARCO toolbox to run this experiment

Pb =10 ;
lambda =1;
nbIter=3000;

run_pcd = 0 ;
run_it = 0 ;
run_l1ls = 0 ;
run_gpsr = 0 ;
run_fpc = 0 ;
run_ppa = 1 ;
run_spgl1 = 0 ;

run_algos=[run_pcd run_it run_l1ls run_gpsr run_fpc run_ppa run_spgl1];

alphas=[0.001 0.01 0.1 1 10 100 1000 10000 100000];

test_problem(Pb, lambda,nbIter,run_algos,alphas);


make_pppa_table_problem(Pb,lambda,500);
make_pppa_table_problem(10,1,3000);



%%%%%%%%%%%%%%%%%%%%%%%
%  comparizon of the algorithms
%
% SCRIPT_compute can be modified to perform massive comparisons

% SCRIPT_compute runs on problem -1, which is not a SPARCO problem
% In order to run this script, you need to be in the correct directory,
% or to give the correct path in bpdn_web/COMMON/test_problem, at the line 19.
% (You probably need to adapt this path anyway if you do not work under Unix/linux.)
%

SCRIPT_compute

run_pcd = 1 ;
run_it = 1 ;
run_l1ls = 0 ;
run_gpsr = 0 ; % we cannot provide GPSR
run_fpc = 0 ;
run_ppa = 1 ;
run_spgl1 = 0 ;

run_algos=[run_pcd run_it run_l1ls run_gpsr run_fpc run_ppa run_spgl1];


make_stat_table_problem(-1,0.1,run_algos,500);
make_stat_table_problem(-1,0.1,run_algos,3000);
make_stat_table_problem(-1,100,run_algos,500);
make_stat_table_problem(-1,100,run_algos,3000);
