function [dk,residual_norm,Ax] = compute_dk(P,b,x,c,alpha,tau)
% [dk,residual_norm,Ax] = compute_dk(P,b,x,c,alpha,tau)
%
% Computes the gradient of the function f_{\alpha,c} 
% grad_f is descent direction in the loop in k of the algorithm
% bp_ppa
%

Ax = P.A(x,1);
dk = 2 * alpha * c + b - Ax ;

norm_dk = norm(dk);

if norm_dk <= tau
   sz = P.A(P.b,0);
   sizeN=cell2mat(sz(1,1));
   dk=zeros(sizeN,1);
else
    dk=(norm_dk-tau) * dk /(2*alpha*norm_dk);
end;

residual_norm = sqrt(mean( ( Ax - b ).^2 ));

return;
