function [a,Da,funct,ell2_pcd,ell1_pcd,ell0_pcd] = bpdn_pcd(P,lambda,nbIter)

% [a,Da,funct,ell2_pcd,ell1_pcd,ell0_pcd] = bpdn_pcd(P,lambda,nbIter)
%
% Finds, wiht the PCD algorithm, a minimizer of 
%            norm(P.A*x - P.b) + lambda * sum(abs( x ))
% where
% b is the image and P.A represents the matrix contained in the sparco problem P
% lambda is a non-negative number
% nbIter is the number of iterations
% 
% The results are :
% x : the coordinates
% Dx : the reconstruction from the coordinates
% funct : a signal containing the value of the functionnal which is minimized, 
%            along the iterative process
% ell2_pcd : a signal containing  sqrt( mean( (P.A*x - b).^2 )), along the iterative process
% ell1_pcd : a signal containing   mean( fabs( x ) ), along the iterative process
% ell0_pcd : a signal containing  100*mean( x~=0 ), along the iterative process
%


% --------------------------------- Creation of data ----------------------------------

x = P.b;

if lambda <= 0,
    fprintf('lambda should be non negative \n');
    return;
end;

siz= P.A(P.b,0);             %%% number of rows and columns in D 
n=cell2mat(siz(1,2));
d=cell2mat(siz(1,1));

 if lambda <= 0,
     fprintf('lambda should be non negative \n');
     return;
 end;

lambda = lambda*0.5;  %%% The PCD algorithm minimizes 
                      %%%    0.5*norm(residual) + lambda * sum(coordinates)
                      %%% For instance, if we want to minimize, with this algorithm, the energy
                      %%%      norm(residual) + 0.1 * sum(coordinates)
                      %%%  since its minimum is also the minimum of
                      %%%    0.5* norm(residual) + 0.05 * sum(coordinates)
                      %%%  we can apply PCD for lambda = 0.05


% ----------------------------------- Run PCD --------------------------------------------
  k=1;
 W_old=ones(n,1);
 ww_old=ones(n,1);
 W=zeros(n,1);
 ww=zeros(n,1);
while ( (norm(W-W_old)/sqrt(n) > 1e-2 ) | (k<30) | (k>10000) ),
     disp([k ]);
     temp=P.A(randn(d,1),2);
     ww_old=ww;
     ww=ww+temp.^2;
     k=k+1;
     W_old=W;
     W=sqrt(ww/k);
end;

a=zeros(n,1);
Da = P.A(a,1);%%% useless, unless the initialization is modified      

%%% few statistics
funct(1) = sum((Da-x(:)).^2)+2*lambda*sum(abs(a));  %%% Remember lambda has been divided by 2
ell0_pcd(1) = 100/length(a)*sum(abs(a)>1e-10);
ell1_pcd(1) = sum(abs(a))/length(a);
ell2_pcd(1) = sqrt(mean((Da-x(:)).^2));


for k = 1:1:nbIter,
    residual = Da(:)-x(:);
    DTresidual = P.A(residual,2); 

    Temp = a-DTresidual./W;
    Temp = soft_threshold(Temp,W,lambda); 

    descent=Temp-a;
    Ddescent=P.A(descent,1);

    [a,Da] = LineSearch(a,Da,residual,descent,Ddescent,x,n,d,lambda); 
                                          
    %%% few statistics

    funct(k+1) = sum((Da-x(:)).^2)+2*lambda*sum(abs(a)); %%% Remember lambda has been divided by 2
    ell0_pcd(k+1) = (100/length(a))*sum(abs(a)>1e-10);
    ell1_pcd(k+1) = sum(abs(a))/length(a);
    ell2_pcd(k+1) = sqrt(mean((Da-x(:)).^2));

    %%% Display statistics
    fprintf('PCD Iteration: %i  funct: %10.5f, [L2,L1,L0]:  %10.5f %10.5f %10.5f  \n',k,funct(k+1)/d,ell2_pcd(k+1),ell1_pcd(k+1),ell0_pcd(k+1));
end;












