function [a,Da] = LineSearch(a,Da,residual,descent,Ddescent,x,n,d,lambda)

% [a,Da] = LineSearch(a,Da,residual,descent,Ddescent,x,n,d,lambda)
%
% In this function we search mu that minimizes the function
% g(mu)=0.5*||residual+mu*Ddescent)||^2+lambda ||a+mu*descent||_1
% where 
% a is the previous solution,
% Da is the multiplication of D by a,
% residual is the previous residual
% descent is the new direction to follow, 
% Ddescent is the multiplication of D by descent,
% x is the data vector, 
% n is the number of collumns in D
% d is the number of rows in D
% lambda is the parameter balancing data fidelity and regularization

step=0;               %%% arbitrary initial value 
evolution = 0.1;      %%% variable for the evolution of the steps
precision = 0.0000001;%%% precision in the computation of the optimal step


%------------------ First loop ----------------
% It looks for an upper bound of the optimal step

step_too_large = step + evolution;

f=0.5*sum((residual+step*Ddescent).^2)+lambda*sum(abs(a+step*descent));
f_too_large=0.5*sum((residual+step_too_large*Ddescent).^2)+lambda*sum(abs(a+step_too_large*descent));


while f_too_large<f,
    evolution=evolution*2;
    f=f_too_large;
    step=step_too_large;
    step_too_large = step + evolution;
    f_too_large=0.5*sum((residual+step_too_large*Ddescent).^2)+lambda*sum(abs(a+step_too_large*descent));
end;

%%% We now have step < step_too_large and f < f_too_large

%------------------ Second loop --------------
% It looks for a lower bound of the optimal step


step_too_small =  step - evolution;
f_too_small=0.5*sum((residual+step_too_small*Ddescent).^2)+lambda*sum(abs(a+step_too_small*descent));
while f_too_small<f,
    evolution=evolution*2;
    f=f_too_small;
    step=step_too_small;
    step_too_small = step - evolution;
    f_too_small=0.5*sum((residual+step_too_small*Ddescent).^2)+lambda*sum(abs(a+step_too_small*descent));
end;

%%% We now also have step_too_small < step and f < f_too_small

%-------------------- Third loop ------------------
%%% We start the dicotomy process
%%% The next loop preserves the above property but makes step_too_large - step_too_small
%%% decrease (it is divided by 2 at every iteration but one).


while (step_too_large - step_too_small) > precision,
    tmp_step_l=(step+step_too_large)/2;
    f_tmp_step_l=0.5*sum((residual+tmp_step_l*Ddescent).^2)+lambda*sum(abs(a+tmp_step_l*descent));
    if f_tmp_step_l < f,
	step_too_small = step;
        f_too_small = f;
        step = tmp_step_l; 
        f = f_tmp_step_l;
    else
      tmp_step_s=(step+step_too_small)/2;
      f_tmp_step_s=0.5*sum((residual+tmp_step_s*Ddescent).^2)+lambda*sum(abs(a+tmp_step_s*descent));
      if f_tmp_step_s < f,
	step_too_large = step;
        f_too_large = f;
        step = tmp_step_s; 
        f = f_tmp_step_s;
      else
        step_too_large = tmp_step_l;
        f_too_large = f_tmp_step_l;
        step_too_small = tmp_step_s;
        f_too_small = f_tmp_step_s;
      end;
     end;

end;

%------------------- end of the optimal step search ------------------------

%%%  update of a and Da

a=a+step*descent;
Da=Da+step*Ddescent;

return;
