function test_problem(ProblemNumber,lambda,nbIter,run_algos,pppa_alpha)
%
%    test_problem(ProblemNumber,lambda,nbIter,run_algos,pppa_alpha)
%
%  test a SPARCO problem, for a given value of lambda.
%  The results are saved in the file  "result_ProblemNumber_lambda"
%  
% ProblemNumber : integer number of the SPARCO problem, generates our DCT problem if ProblemNumber== -1)
% lambda : float value for lambda in the Basis Pursuit Denoising
% nbIter : number of iteration for the different algorithms
% run_algos : describes the algorithms which are applied (see example in SCRIPT_compute)
% pppa_alpha : values of alpha for the PPPA (must be of odd size)
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INITIALISATION 

if ProblemNumber==-1,
    P = generate_dct_Pb('../data/img.gif');
else
    P = generateProblem(ProblemNumber);
end;

b  = P.b;            % The right-hand-side vector.

trash = P.A(P.b,0); % m is the no. of rows and n is the no. of columns.
m=cell2mat(trash(1,1));
n=cell2mat(trash(1,2));

Dnorm = get_operator_norm(P,1);

% matrix containing the results
total0=[];
total1=[];
total2=[];
totaln=[];

% variable describing the index of the result of an algorithm as a function of the algorithm
pcd= 0;
it= 0;
spgl1_index= 0;
l1_ls_index= 0;
fpc_index= 0;
pppa_1=zeros(size(pppa_alpha));
pppa_2 = 0;
pppa_3=0;
gpsr_index=0;
algoNumber= 0;

% variable selecting which algorithms are tested
run_pcd = 1 ;  % we always run pcd, to test the problem
run_it =  run_algos(2) ;
run_l1ls =  run_algos(3) ;
run_gpsr = run_algos(4) ;
run_fpc =  run_algos(5) ;
run_pppa =  run_algos(6) ;
run_spgl1 = run_algos(7) ;

% the result are saved in the following file
% you need to load it to analyse the results

[file_name, errmsg] = sprintf('result_%d_%g.mat',ProblemNumber,lambda); 

% the coordinates for the various algorithms

AllA=[];
 
% Pb_OK    (The function does not test all the algorithms if the solution is 0)

Pb_OK =1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN  ALL THE ALGORITHMS USING lambda

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN PCD

if run_pcd ~=0,
[a,Da,funct_pcd,ell2_pcd,ell1_pcd,ell0_pcd] = bpdn_pcd(P,lambda,nbIter-1);

algoNumber = algoNumber+1;
pcd=algoNumber;   % line number of PCD in total

AllA=[AllA a];

size_pcd= size(funct_pcd,2);
if size_pcd < nbIter
total0=[total0 ; ell0_pcd , ell0_pcd(size_pcd) *ones(1,nbIter-size_pcd) ];
total1=[total1 ; ell1_pcd , ell1_pcd(size_pcd) *ones(1,nbIter-size_pcd)];
total2=[total2 ; ell2_pcd , ell2_pcd(size_pcd) *ones(1,nbIter-size_pcd)];
totaln=[totaln ; funct_pcd , funct_pcd(size_pcd) *ones(1,nbIter-size_pcd)];
else
total0=[total0 ; ell0_pcd(1:nbIter)];
total1=[total1 ; ell1_pcd(1:nbIter)];
total2=[total2 ; ell2_pcd(1:nbIter)];
totaln=[totaln ; funct_pcd(1:nbIter)];
end
end

% test if Problem is non trivial
if total0(pcd,nbIter)==0,
  Pb_OK=0;
  it=pcd;
  l1_ls_index=pcd;
  tau=total2(pcd,nbIter);
  gpsr_index=pcd;
  fpc_index=pcd;
  pppa_1=pcd*ones(1,length(pppa_alpha));
  pppa_2=pcd;
  pppa_3=pcd;
  spgl1_index=pcd;
end;


%save(file_name);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN IT
if run_it~=0  && Pb_OK~=0,
[a,Da,funct_it,ell2_it,ell1_it,ell0_it] = bpdn_it(P,lambda,nbIter-1,Dnorm);

algoNumber = algoNumber+1;
it=algoNumber;    % line number of IT in total

AllA=[AllA a];

size_it= size(funct_it,2);
if size_it < nbIter
total0=[total0 ; ell0_it , ell0_it(size_it) *ones(1,nbIter-size_it) ];
total1=[total1 ; ell1_it , ell1_it(size_it) *ones(1,nbIter-size_it)];
total2=[total2 ; ell2_it , ell2_it(size_it) *ones(1,nbIter-size_it)];
totaln=[totaln ; funct_it , funct_it(size_it) *ones(1,nbIter-size_it)];
else
total0=[total0 ; ell0_it(1:nbIter)];
total1=[total1 ; ell1_it(1:nbIter)];
total2=[total2 ; ell2_it(1:nbIter)];
totaln=[totaln ; funct_it(1:nbIter)];
end
end

%save(file_name);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN L1_LS
% We do not provide l1_ls_sparcoter.

if run_l1ls~=0 && Pb_OK~=0,
[a,Da,funct_l1ls,ell2_l1ls,ell1_l1ls,ell0_l1ls] = l1_ls_sparcoter(P, ProblemNumber,nbIter,b,lambda);

algoNumber = algoNumber+1;
l1_ls_index= algoNumber;    % line number of L1_LS in total

AllA=[AllA a];

size_l1ls= size(funct_l1ls,2);
if size_l1ls < nbIter
total0=[total0 ; ell0_l1ls , ell0_l1ls(size_l1ls) *ones(1,nbIter-size_l1ls) ];
total1=[total1 ; ell1_l1ls , ell1_l1ls(size_l1ls) *ones(1,nbIter-size_l1ls)];
total2=[total2 ; ell2_l1ls , ell2_l1ls(size_l1ls) *ones(1,nbIter-size_l1ls)];
totaln=[totaln ; funct_l1ls , funct_l1ls(size_l1ls) *ones(1,nbIter-size_l1ls)];
else
total0=[total0 ; ell0_l1ls(1:nbIter)];
total1=[total1 ; ell1_l1ls(1:nbIter)];
total2=[total2 ; ell2_l1ls(1:nbIter)];
totaln=[totaln ; funct_l1ls(1:nbIter)];
end
end

%save(file_name);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN GPSR
% We do not provide GPSR_BB. It can be downloaded on the web and adapted to
% provide our statistics

if run_gpsr~=0 && Pb_OK~=0,
	       
A  = @(x) P.A(x,1);  % The operator
AT = @(y) P.A(y,2);  % and its transpose.

[a,x_debias,objective,times,debias_start,mses,ell0_gpsr,ell1_gpsr,ell2_gpsr,funct_gpsr]=GPSR_BB(P.b,A,0.5*lambda,'AT',AT,'MINITERA',nbIter,'MAXITERA',nbIter);

algoNumber = algoNumber+1;
gpsr_index=algoNumber;    % line number of gpsr in total

AllA=[AllA a];

size_gpsr= size(funct_gpsr,2);
if size_gpsr < nbIter
total0=[total0 ; ell0_gpsr , ell0_gpsr(size_gpsr) *ones(1,nbIter-size_gpsr) ];
total1=[total1 ; ell1_gpsr , ell1_gpsr(size_gpsr) *ones(1,nbIter-size_gpsr)];
total2=[total2 ; ell2_gpsr , ell2_gpsr(size_gpsr) *ones(1,nbIter-size_gpsr)];
totaln=[totaln ; funct_gpsr , funct_gpsr(size_gpsr) *ones(1,nbIter-size_gpsr)];
else
total0=[total0 ; ell0_gpsr(1:nbIter)];
total1=[total1 ; ell1_gpsr(1:nbIter)];
total2=[total2 ; ell2_gpsr(1:nbIter)];
totaln=[totaln ; funct_gpsr(1:nbIter)];
end
end

%save(file_name);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN FPC
% We do not provide fpc_sparco.

if run_fpc~=0 && Pb_OK~=0,
opts = fpc_opts([]);
opts.init = 0;
opts.mxitr = nbIter-1;
%opts.xtol=0;
%opts.gtol=0;
A=@AandAt;

% [x,Da,funct_fpc,ell2_fpc,ell1_fpc,ell0_fpc]
 [Out,funct_fpc,ell2_fpc,ell1_fpc,ell0_fpc]  = fpc_sparco(n,A,b,lambda,[],opts,P);

a=Out.x;

algoNumber = algoNumber+1;
fpc_index=algoNumber;    % line number of FPC in total

AllA=[AllA a];

size_fpc= size(funct_fpc,2);
if size_fpc < nbIter
total0=[total0 ; ell0_fpc , ell0_fpc(size_fpc) *ones(1,nbIter-size_fpc) ];
total1=[total1 ; ell1_fpc , ell1_fpc(size_fpc) *ones(1,nbIter-size_fpc)];
total2=[total2 ; ell2_fpc , ell2_fpc(size_fpc) *ones(1,nbIter-size_fpc)];
totaln=[totaln ; funct_fpc , funct_fpc(size_fpc) *ones(1,nbIter-size_fpc)];
else
total0=[total0 ; ell0_fpc(1:nbIter)];
total1=[total1 ; ell1_fpc(1:nbIter)];
total2=[total2 ; ell2_fpc(1:nbIter)];
totaln=[totaln ; funct_fpc(1:nbIter)];
end
end
%save(file_name);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN  ALL THE ALGORITHMS USING tau

%%%%% compute tau first
if isempty(total2)
  tau=lambda;
elseif size(total2,1) ==1,
  tau=lambda;
else
  j=1;
  for i=2:size(total2,1);
     if total2(i,nbIter)<total2(j,nbIter),
       j=i;
     end;
  end;
  tau=total2(j,nbIter);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN PPPA

% alpha is constant 
if run_pppa ~= 0 && Pb_OK~=0,
for i=1:1:length(pppa_alpha),
   [a,Da,funct_pppa,ell2_pppa,ell1_pppa,ell0_pppa,alpha_pppa] = bpdn_pppa(P,tau,nbIter,pppa_alpha(i),1,lambda,Dnorm);

   algoNumber = algoNumber+1;
   pppa_1(i)=algoNumber;    % line number of pppa with pppa_alpha(i) in total

   AllA=[AllA a];

   size_pppa= size(funct_pppa,2);
   if size_pppa < nbIter
   total0=[total0 ; ell0_pppa , ell0_pppa(size_pppa) *ones(1,nbIter-size_pppa) ];
   total1=[total1 ; ell1_pppa , ell1_pppa(size_pppa) *ones(1,nbIter-size_pppa)];
   total2=[total2 ; ell2_pppa , ell2_pppa(size_pppa) *ones(1,nbIter-size_pppa)];
   totaln=[totaln ; funct_pppa , funct_pppa(size_pppa) *ones(1,nbIter-size_pppa)];
   else
   total0=[total0 ; ell0_pppa(1:nbIter)];
   total1=[total1 ; ell1_pppa(1:nbIter)];
   total2=[total2 ; ell2_pppa(1:nbIter)];
   totaln=[totaln ; funct_pppa(1:nbIter)];
   end
 end;

%save(file_name);

%% alpha varies according to rule 2 (PPPA 2)

if run_pppa~= 0  && length(pppa_alpha) > 1  && Pb_OK~=0;
[a,Da,funct_pppa,ell2_pppa,ell1_pppa,ell0_pppa,alpha_pppa] = bpdn_pppa(P,tau,nbIter,[pppa_alpha(1),pppa_alpha(length(pppa_alpha))],2,lambda,Dnorm);
   
   algoNumber = algoNumber+1;
   pppa_2=algoNumber;    % line number of pppa with alpha varies according to rule 2

   AllA=[AllA a];


   size_pppa= size(funct_pppa,2);
   if size_pppa < nbIter
   total0=[total0 ; ell0_pppa , ell0_pppa(size_pppa) *ones(1,nbIter-size_pppa) ];
   total1=[total1 ; ell1_pppa , ell1_pppa(size_pppa) *ones(1,nbIter-size_pppa)];
   total2=[total2 ; ell2_pppa , ell2_pppa(size_pppa) *ones(1,nbIter-size_pppa)];
   totaln=[totaln ; funct_pppa , funct_pppa(size_pppa) *ones(1,nbIter-size_pppa)];
   else
   total0=[total0 ; ell0_pppa(1:nbIter)];
   total1=[total1 ; ell1_pppa(1:nbIter)];
   total2=[total2 ; ell2_pppa(1:nbIter)];
   totaln=[totaln ; funct_pppa(1:nbIter)];
   end
end;
%% alpha varies according to rule 3

if run_pppa~= 0  && Pb_OK~=0;
   [a,Da,funct_pppa,ell2_pppa,ell1_pppa,ell0_pppa,alpha_pppa1] = bpdn_pppa(P,tau,nbIter,pppa_alpha(3),3,lambda,Dnorm);
   
   algoNumber = algoNumber+1;
   pppa_3=algoNumber;    % line number of pppa with alpha varies according to rule 3

   AllA=[AllA a];


   size_pppa= size(funct_pppa,2);
   if size_pppa < nbIter
   total0=[total0 ; ell0_pppa , ell0_pppa(size_pppa) *ones(1,nbIter-size_pppa) ];
   total1=[total1 ; ell1_pppa , ell1_pppa(size_pppa) *ones(1,nbIter-size_pppa)];
   total2=[total2 ; ell2_pppa , ell2_pppa(size_pppa) *ones(1,nbIter-size_pppa)];
   totaln=[totaln ; funct_pppa , funct_pppa(size_pppa) *ones(1,nbIter-size_pppa)];
   else
   total0=[total0 ; ell0_pppa(1:nbIter)];
   total1=[total1 ; ell1_pppa(1:nbIter)];
   total2=[total2 ; ell2_pppa(1:nbIter)];
   totaln=[totaln ; funct_pppa(1:nbIter)];
   end
end;
end
%save(file_name);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RUN SPGL1
% We do not provide  SPGL1

if run_spgl1 ~= 0 && Pb_OK~=0,
options.iterations = nbIter-1;
options.optTol = 1e-6;
[a,residu,grad,info,ell0_spgl1,ell1_spgl1,ell2_spgl1,funct_spgl1]= spgl1_sparco( P.A, P.b, 0, tau, [], options,lambda);

algoNumber = algoNumber+1;
spgl1_index=algoNumber;    % line number of SPGL in total

AllA=[AllA a];

size_spgl1= size(funct_spgl1,2);
if size_spgl1 < nbIter
total0=[total0 ; ell0_spgl1 , ell0_spgl1(size_spgl1) *ones(1,nbIter-size_spgl1) ];
total1=[total1 ; ell1_spgl1 , ell1_spgl1(size_spgl1) *ones(1,nbIter-size_spgl1)];
total2=[total2 ; ell2_spgl1 , ell2_spgl1(size_spgl1) *ones(1,nbIter-size_spgl1)];
totaln=[totaln ; funct_spgl1 , funct_spgl1(size_spgl1) *ones(1,nbIter-size_spgl1)];
else
total0=[total0 ; ell0_spgl1(1:nbIter)];
total1=[total1 ; ell1_spgl1(1:nbIter)];
total2=[total2 ; ell2_spgl1(1:nbIter)];
totaln=[totaln ; funct_spgl1(1:nbIter)];
end
end


save(file_name);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
