function print_table()
%
% print a table which has already been saved in a file table.mat
%
% This function creates a tabular in latex format


load('table.mat');

nbAlgo = length(my_line)-2;

%%%%%%%%%%%%%
% first line

stg='\begin{tabular}{|c|c';
for i=1:nbAlgo,
	stg=strcat(stg,'|c');
end;
stg = strcat(stg,'|}\\hline');

disp(stg);

%%%%%%%%%%%
% second line 
toDisp = ' Problem & lambda '; 

if disp_algos(2) ~= 0,   %IT
  toDisp=strcat(toDisp,'& IT ');
end;

if disp_algos(1) ~= 0,   %PCD
  toDisp=strcat(toDisp,'& PCD');
end

if disp_algos(4) ~= 0,   %GPSR
  toDisp=strcat(toDisp,'& GPSR ');
end

if disp_algos(5) ~= 0,   %FPC
  toDisp=strcat(toDisp,'& FPC ');
end

if disp_algos(6) ~= 0,   %PPPA
  toDisp=strcat(toDisp,'& PPPA 1 ');
toDisp=strcat(toDisp,'& PPPA 2 ');
end

if disp_algos(3) ~= 0,   %L1_LS
  toDisp=strcat(toDisp,'& L1LS ');
end

if disp_algos(7) ~= 0,   %SPGL1
  toDisp=strcat(toDisp,' & SPGL1 ');
end

toDisp=strcat(toDisp,'\\ \hline' );
disp(toDisp);

%%%%%%%%%%%%%%%%%%%%%%%%
% All lines 

linelength=nbAlgo+2;
nbPb=size(result,1);

for pb= 1:nbPb,
    strg = sprintf(' %g ',result(pb,1));
    for j=2:linelength, 
            if result(pb,j)==3001,
                [tmp,errmsg] = sprintf(' & NC ');
            else
                [tmp,errmsg] = sprintf(' & %g ',result(pb,j));
            end;
	    strg = strcat(strg,tmp);
    end;
    strg = strcat(strg,'\\ \hline');
    disp(strg);
end;
%%%%%%%%%%%%%%%%%%%%%%%%
% Last line

disp('\end{tabular}'); 

