function plot_problem(ProblemNumber,lambda)
%
%    plot_problem(ProblemNumber,lambda)
%
%  plot the results of a SPARCO problem, for a given value of lambda.
%  The result have been saved in the file  "result_ProblemNumber_lambda"
%  
% ProblemNumber : integer number of the SPARCO problem
% lambda : float value for lambda in the Basis Pursuit Denoising
%
 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LOAD RESULTS and INITIALISATION
  ppa_lin1=0;

[name, errmsg] = sprintf('result_%d_%g.mat',ProblemNumber,lambda); 

load(name);

%%%%%%%%%%%%%%%%%%%%%%%%%%
% select ppa_alpha

index_alpha=1;
if ppa(1)~=0,
  index_alpha=1;
  funct_min=totaln(ppa(1),nbIter);
  for i=2:length(ppa),
	if funct_min>totaln(ppa(i),nbIter),
	    funct_min=totaln(ppa(i),nbIter);
            index_alpha=i;
        end;
  end;
end;
%index_alpha = round( (length(ppa_alpha) +1) / 2);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% global test of convergence

pcd_OK=1;
it_OK=1;
l1ls_OK=1;
gpsr_OK=1;
fpc_OK=1;
ppa_OK=1;
spgl1_OK=1;

if pcd~=0,
  if isnan(total2(pcd,nbIter)),
     pcd_OK =0 ;
     disp('WARNING :      PCD did diverge');
  end;
end;

if it~=0,
  if isnan(total2(it,nbIter)),
     it_OK =0 ;
     disp('WARNING :      IT did diverge');
  end;
end;

if l1_ls_index~=0,
  if isnan(total2(l1_ls_index,nbIter)),
     l1ls_OK =0 ;
     disp('WARNING :      L1LS did diverge');
  end;
end;

if gpsr_index~=0,
  if isnan(total2(gpsr_index,nbIter)),
     gpsr_OK =0 ;
     disp('WARNING :      GPSR did diverge');
  end;
end;

if fpc_index~=0,
  if isnan(total2(fpc_index,nbIter)),
     fpc_OK =0 ;
     disp('WARNING :      FPC did diverge');
  end;
end;

if ppa(index_alpha)~=0,
  if isnan(total2(ppa(index_alpha),nbIter)),
     ppa_OK =0 ;
     disp('WARNING :      PPA did diverge');
  end;
end;

if spgl1_index~=0,
  if isnan(total2(spgl1_index,nbIter)),
     spgl1_OK =0 ;
     disp('WARNING :      SPGL1 did diverge');
  end;
end;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PLOT CURVES L0

base = 'l0 stat for ';
Pit=[];Pppa=[];Ppcd=[];Pspgl1=[];Pl1_ls=[];Pfpc=[];Pgpsr=[];
Mess=[];
figure(1); clf; 
% plot PCD if necessary 
if pcd ~= 0 && pcd_OK==1;
   [pcdMess, errmsg] = sprintf(' PCD, lambda = %g (leads to l0 = %g)',lambda,real(total0(pcd,nbIter)));
   Mess =strvcat(Mess , strcat(base,pcdMess));
   Ppcd = plot(1:nbIter,real(total0(pcd,:)),'b'); hold on;
end;
% plot IT if necessary 
if it ~= 0  && it_OK==1;
   [itMess, errmsg] = sprintf(' IT, lambda = %g (leads to l0 = %g)',lambda,real(total0(it,nbIter))); 
   Mess =strvcat(Mess ,  strcat(base,itMess));
   Pit = plot(1:nbIter,real(total0(it,:)),'g'); hold on;
  
end;
% plot L1_LS if necessary 
if l1_ls_index ~= 0  && l1ls_OK==1;
   [l1_lsMess, errmsg] = sprintf(' L1LS, lambda = %g (leads to l0 = %g)',lambda,real(total0(l1_ls_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,l1_lsMess));
   Pl1_ls = plot(1:nbIter,real(total0(l1_ls_index,:)),'m'); hold on;
end;
% plot FPC if necessary 
if fpc_index ~= 0  && fpc_OK==1;
   [fpcMess, errmsg] = sprintf(' FPC, lambda = %g (leads to l0 = %g)',lambda,real(total0(fpc_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,fpcMess));
   Pfpc = plot(1:nbIter,real(total0(fpc_index,:)),'y'); hold on;
end;
% plot GPSR if necessary 
if gpsr_index ~= 0  && gpsr_OK==1;
   [gpsrMess, errmsg] = sprintf(' GPSR, lambda = %g (leads to l0 = %g)',lambda,real(total0(gpsr_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,gpsrMess));
   Pgpsr = plot(1:nbIter,real(total0(gpsr_index,:)),'k'); hold on;
end;
% plot SPGL1 if necessary 
if spgl1_index ~= 0  && spgl1_OK==1;
   [spglMess, errmsg] = sprintf(' SPGL1, target MSE =  %g (leads to l0 = %g)',tau,real(total0(spgl1_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,spglMess));
   Pspgl = plot(1:nbIter,real(total0(spgl1_index,:)),'c'); hold on;
end;
% plot PPPA if necessary 
if length(ppa_alpha) ~= 0 & ppa(index_alpha) ~= 0  && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 1, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index_alpha),real(total0(ppa(index_alpha),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index_alpha),:)),'r'); hold on;
end;
% plot PPPA if necessary 
if ppa_lin ~= 0 && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 2, target MSE = %g, final alpha = %g and leads to l0 = %g',tau,alpha_ppa(nbIter),real(total0(ppa_lin,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa_lin,:)),'r:'); hold on;
end;
% plot PPPA if necessary 
if ppa_lin1 ~= 0 && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 3, target MSE = %g, final alpha = %g and leads to l0 = %g',tau,alpha_ppa1(nbIter),real(total0(ppa_lin1,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa_lin1,:)),'r--'); hold on;
end;

legend(Mess);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PLOT CURVES L1

base = 'l1 stat for ';
Pit=[];Pppa=[];Ppcd=[];Pspgl1=[];Pl1_ls=[];Pfpc=[];Pgpsr=[];
Mess=[];
figure(2); clf; 
% plot PCD if necessary 
if pcd ~= 0  && pcd_OK==1;
   [pcdMess, errmsg] = sprintf(' PCD, lambda = %g (leads to l1 = %g)',lambda,real(total1(pcd,nbIter)));
   Mess =strvcat(Mess , strcat(base,pcdMess));
   Ppcd = plot(1:nbIter,real(total1(pcd,:)),'b'); hold on;
end;
% plot IT if necessary 
if it ~= 0  && it_OK==1;
   [itMess, errmsg] = sprintf(' IT, lambda = %g (leads to l1 = %g)',lambda,real(total1(it,nbIter))); 
   Mess =strvcat(Mess ,  strcat(base,itMess));
   Pit = plot(1:nbIter,real(total1(it,:)),'g'); hold on;
  
end;
% plot L1_LS if necessary 
if l1_ls_index ~= 0  && l1ls_OK==1;
   [l1_lsMess, errmsg] = sprintf(' L1LS, lambda = %g (leads to l1 = %g)',lambda,real(total1(l1_ls_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,l1_lsMess));
   Pl1_ls = plot(1:nbIter,real(total1(l1_ls_index,:)),'m'); hold on;
end;
% plot FPC if necessary 
if fpc_index ~= 0  && fpc_OK==1;
   [fpcMess, errmsg] = sprintf(' FPC, lambda = %g (leads to l1 = %g)',lambda,real(total1(fpc_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,fpcMess));
   Pfpc = plot(1:nbIter,real(total1(fpc_index,:)),'y'); hold on;
end;
% plot GPSR if necessary 
if gpsr_index ~= 0  && gpsr_OK==1;
   [gpsrMess, errmsg] = sprintf(' GPSR, lambda = %g (leads to l1 = %g)',lambda,real(total1(gpsr_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,gpsrMess));
   Pgpsr = plot(1:nbIter,real(total1(gpsr_index,:)),'k'); hold on;
end;
% plot SPGL1 if necessary 
if spgl1_index ~= 0  && spgl1_OK==1;
   [spglMess, errmsg] = sprintf(' SPGL1, target MSE = %g (leads to l1 = %g)',tau,real(total1(spgl1_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,spglMess));
   Pspgl = plot(1:nbIter,real(total1(spgl1_index,:)),'c'); hold on;
end;
% plot PPPA if necessary 
if length(ppa_alpha) ~= 0 & ppa(index_alpha) ~= 0  && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 1, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index_alpha),real(total1(ppa(index_alpha),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index_alpha),:)),'r'); hold on;
end;
% plot PPPA if necessary 
if ppa_lin ~= 0 && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 2, target MSE = %g, final alpha = %g and leads to l1 = %g',tau,alpha_ppa(nbIter),real(total1(ppa_lin,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa_lin,:)),'r:'); hold on;
end;
% plot PPPA if necessary 
if ppa_lin1 ~= 0 && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 3, target MSE = %g, final alpha = %g and leads to l1 = %g',tau,alpha_ppa1(nbIter),real(total1(ppa_lin1,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa_lin1,:)),'r--'); hold on;
end;

legend(Mess);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PLOT CURVES L2
acc = 1e-6;
base = 'l2 stat for ';
Pit=[];Pppa=[];Ppcd=[];Pspgl1=[];Pl1_ls=[];Pfpc=[];Pgpsr=[];
Mess=[];
figure(4); clf; 
% plot PCD if necessary 
if pcd ~= 0  && pcd_OK==1;
   [pcdMess, errmsg] = sprintf(' PCD, lambda = %g (leads to MSE = %g)',lambda,real(total2(pcd,nbIter)));
   Mess =strvcat(Mess , strcat(base,pcdMess));
   Ppcd = semilogy(1:nbIter,acc+abs(real(total2(pcd,:))-tau),'b'); hold on;
end;
% plot IT if necessary 
if it ~= 0  && it_OK==1;
   [itMess, errmsg] = sprintf(' IT, lambda = %g (leads to MSE = %g)',lambda,real(total2(it,nbIter))); 
   Mess =strvcat(Mess ,  strcat(base,itMess));
   Pit = semilogy(1:nbIter,acc+abs(real(total2(it,:))-tau),'g'); hold on;
  
end;
% plot L1_LS if necessary 
if l1_ls_index ~= 0  && l1ls_OK==1;
   [l1_lsMess, errmsg] = sprintf(' L1LS, lambda = %g (leads to MSE = %g)',lambda,real(total2(l1_ls_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,l1_lsMess));
   Pl1_ls = semilogy(1:nbIter,acc+abs(real(total2(l1_ls_index,:))-tau),'m'); hold on;
end;
% plot FPC if necessary 
if fpc_index ~= 0  && fpc_OK==1;
   [fpcMess, errmsg] = sprintf(' FPC, lambda = %g (leads to MSE = %g)',lambda,real(total2(fpc_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,fpcMess));
   Pfpc = semilogy(1:nbIter,acc+abs(real(total2(fpc_index,:))-tau),'y'); hold on;
end;
% plot GPSR if necessary 
if gpsr_index ~= 0  && gpsr_OK==1;
   [gpsrMess, errmsg] = sprintf(' GPSR, lambda = %g (leads to MSE = %g)',lambda,real(total2(gpsr_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,gpsrMess));
   Pgpsr = semilogy(1:nbIter,acc+abs(real(total2(gpsr_index,:))-tau),'k'); hold on;
end;
% plot SPGL1 if necessary 
if spgl1_index ~= 0  && spgl1_OK==1;
   [spglMess, errmsg] = sprintf(' SPGL1, target MSE = %g (leads to MSE = %g)',tau,real(total2(spgl1_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,spglMess));
   Pspgl = semilogy(1:nbIter,acc+abs(real(total2(spgl1_index,:))-tau),'c'); hold on;
end;
% plot PPPA if necessary 
if length(ppa_alpha) ~= 0 & ppa(index_alpha) ~= 0  && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 1, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index_alpha),real(total2(ppa(index_alpha),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index_alpha),:))-tau),'r'); hold on;
end;
% plot PPPA if necessary 
if ppa_lin~=0  && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 2, target MSE = %g and alpha = %g and leads to MSE = %g',tau,alpha_ppa(nbIter),real(total2(ppa_lin,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa_lin,:))-tau),'r:'); hold on;
end;
% plot PPPA if necessary 
if ppa_lin1~=0  && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 3, target MSE = %g and alpha = %g and leads to MSE = %g',tau,alpha_ppa1(nbIter),real(total2(ppa_lin1,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa_lin1,:))-tau),'r--'); hold on;
end;

legend(Mess);





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PLOT CURVES functional

base = 'functional stat for ';
Pit=[];Pppa=[];Ppcd=[];Pspgl1=[];Pl1_ls=[];Pfpc=[];Pgpsr=[];
Mess=[];
figure(3); clf; 
% plot PCD if necessary 
if pcd ~= 0  && pcd_OK==1;
   [pcdMess, errmsg] = sprintf(' PCD, lambda = %g (leads to func = %g)',lambda,real(totaln(pcd,nbIter)));
   Mess =strvcat(Mess , strcat(base,pcdMess));
Ppcd = semilogy(1:nbIter,real(totaln(pcd,:)),'b'); hold on;
end;
% plot IT if necessary 
if it ~= 0  && it_OK==1;
   [itMess, errmsg] = sprintf(' IT, lambda = %g (leads to func = %g)',lambda,real(totaln(it,nbIter))); 
   Mess =strvcat(Mess ,  strcat(base,itMess));
   Pit =  semilogy(1:nbIter,real(totaln(it,:)),'g'); hold on;
  
end;
% plot L1_LS if necessary 
if l1_ls_index ~= 0  && l1ls_OK==1;
   [l1_lsMess, errmsg] = sprintf(' L1LS, lambda = %g (leads to func = %g)',lambda,real(totaln(l1_ls_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,l1_lsMess));
   Pl1_ls = semilogy(1:nbIter,real(totaln(l1_ls_index,:)),'m'); hold on;
end;
% plot FPC if necessary 
if fpc_index ~= 0  && fpc_OK==1;
   [fpcMess, errmsg] = sprintf(' FPC, lambda = %g (leads to func = %g)',lambda,real(totaln(fpc_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,fpcMess));
   Pfpc = semilogy(1:nbIter,real(totaln(fpc_index,:)),'y'); hold on;
end;
% plot GPSR if necessary 
if gpsr_index ~= 0  && gpsr_OK==1;
   [gpsrMess, errmsg] = sprintf(' GPSR, lambda = %g (leads to func = %g)',lambda,real(totaln(gpsr_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,gpsrMess));
   Pgpsr = semilogy(1:nbIter,real(totaln(gpsr_index,:)),'k'); hold on;
end;
% plot SPGL1 if necessary 
if spgl1_index ~= 0  && spgl1_OK==1;
   [spglMess, errmsg] = sprintf(' SPGL1, target MSE = %g (leads to func = %g)',tau,real(totaln(spgl1_index,nbIter)));
   Mess =strvcat(Mess , strcat(base,spglMess));
   Pspgl = semilogy(1:nbIter,real(totaln(spgl1_index,:)),'c'); hold on;
end;
% plot PPPA if necessary 
if length(ppa_alpha) ~= 0 & ppa(index_alpha) ~= 0  && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 1, target MSE = %g and alpha = %g and leads to func = %g',tau,ppa_alpha(index_alpha),real(totaln(ppa(index_alpha),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,real(totaln(ppa(index_alpha),:)),'r'); hold on;
end;
% plot PPPA if necessary 
if ppa_lin ~= 0 && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 2, target MSE = %g, final alpha = %g and leads to func = %g',tau,alpha_ppa(nbIter),real(totaln(ppa_lin,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,real(totaln(ppa_lin,:)),'r:'); hold on;
end;
% plot PPPA if necessary 
if ppa_lin1 ~= 0 && ppa_OK==1;
   [ppaMess, errmsg] = sprintf(' PPPA 3, target MSE = %g, final alpha = %g and leads to func = %g',tau,alpha_ppa1(nbIter),real(totaln(ppa_lin1,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,real(totaln(ppa_lin1,:)),'r--'); hold on;
end;

legend(Mess);



