function plot_ppa(ProblemNumber,lambda)
%
%    plot_ppa(ProblemNumber,lambda)
%
%  plot the results of a SPARCO problem with the PPA algo, 
%  for a given value of lambda.
%  The result have been saved in the file  "result_ProblemNumber_lambda"
%  
% ProblemNumber : integer number of the SPARCO problem
% lambda : float value for lambda in the Basis Pursuit Denoising
%
 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LOAD RESULTS and INITIALISATION
  ppa_lin1=0;

[name, errmsg] = sprintf('result_%d_%g.mat',ProblemNumber,lambda); 

load(name);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PLOT CURVES L0

base = 'l0 stat for ';
Mess=[];
figure(1); clf; 

index =1;
if index <= length(ppa_alpha),
  [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index),real(total0(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index),:)),'b'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
  [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index),real(total0(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index),:)),'r'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index),real(total0(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index),:)),'g'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index),real(total0(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index),:)),'c'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index),real(total0(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index),:)),'m'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index),real(total0(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index),:)),'y'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index),real(total0(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index),:)),'k:'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index),real(total0(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index),:)),'k--'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index),real(total0(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index),:)),'g:'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l0 = %g',tau,ppa_alpha(index),real(total0(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa(index),:)),'g--'); hold on;
   index=index+1;
end;
if ppa_lin~=0,
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha varying and leads to l0 = %g',tau,real(total0(ppa_lin,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa_lin,:)),'r:'); hold on;
end
if ppa_lin1~=0,
   [ppaMess, errmsg] = sprintf(' PPPA 2, target MSE = %g and alpha varying and leads to l0 = %g',tau,real(total0(ppa_lin1,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total0(ppa_lin1,:)),'r--'); hold on;
end

legend(Mess);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PLOT CURVES L1

base = 'l1 stat for ';
Mess=[];
figure(2); clf; 

index =1;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index),real(total1(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index),:)),'b'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index),real(total1(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index),:)),'r'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index),real(total1(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index),:)),'g'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index),real(total1(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index),:)),'c'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index),real(total1(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index),:)),'m'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index),real(total1(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index),:)),'y'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index),real(total1(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index),:)),'k:'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index),real(total1(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index),:)),'k--'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index),real(total1(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index),:)),'g:'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to l1 = %g',tau,ppa_alpha(index),real(total1(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa(index),:)),'g--'); hold on;
   index=index+1;
end;
if ppa_lin~=0,
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha varying and leads to l1 = %g',tau,real(total1(ppa_lin,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa_lin,:)),'r:'); hold on;
end
if ppa_lin1~=0,
   [ppaMess, errmsg] = sprintf(' PPPA 2, target MSE = %g and alpha varying and leads to l1 = %g',tau,real(total1(ppa_lin1,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(total1(ppa_lin1,:)),'r--'); hold on;
end

legend(Mess);






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PLOT CURVES L2
acc = 1e-6;
base = 'l2 stat for ';
Mess=[];
figure(4); clf; 

index =1;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index),real(total2(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index),:))-tau),'b'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index),real(total2(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index),:))-tau),'r'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index),real(total2(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index),:))-tau),'g'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index),real(total2(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index),:))-tau),'c'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index),real(total2(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index),:))-tau),'m'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index),real(total2(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index),:))-tau),'y'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index),real(total2(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index),:))-tau),'k:'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index),real(total2(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index),:))-tau),'k--'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index),real(total2(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index),:))-tau),'g:'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to MSE = %g',tau,ppa_alpha(index),real(total2(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa(index),:))-tau),'g--'); hold on;
   index=index+1;
end;
if ppa_lin~=0,
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha varying and leads to MSE = %g',tau,real(total2(ppa_lin,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa_lin,:))-tau),'r:'); hold on;
end
if ppa_lin1~=0,
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha varying and leads to MSE = %g',tau,real(total2(ppa_lin1,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = semilogy(1:nbIter,acc+abs(real(total2(ppa_lin1,:))-tau),'r--'); hold on;
end
   legend(Mess);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PLOT CURVES FUNC

base = 'functional for ';
Mess=[];
figure(3); clf; 

index =1;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to funct. = %g',tau,ppa_alpha(index),real(totaln(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa(index),:)),'b'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to funct. = %g',tau,ppa_alpha(index),real(totaln(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa(index),:)),'r'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to funct. = %g',tau,ppa_alpha(index),real(totaln(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa(index),:)),'g'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to funct. = %g',tau,ppa_alpha(index),real(totaln(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa(index),:)),'c'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to funct. = %g',tau,ppa_alpha(index),real(totaln(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa(index),:)),'m'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to funct. = %g',tau,ppa_alpha(index),real(totaln(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa(index),:)),'y'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to funct. = %g',tau,ppa_alpha(index),real(totaln(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa(index),:)),'k:'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to funct. = %g',tau,ppa_alpha(index),real(totaln(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa(index),:)),'k--'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to funct. = %g',tau,ppa_alpha(index),real(totaln(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa(index),:)),'g:'); hold on;
   index=index+1;
end;
if index <= length(ppa_alpha),
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha = %g and leads to funct. = %g',tau,ppa_alpha(index),real(totaln(ppa(index),nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa(index),:)),'g--'); hold on;
   index=index+1;
end;
if ppa_lin~=0,
   [ppaMess, errmsg] = sprintf(' PPPA, target MSE = %g and alpha varying and leads to funct. = %g',tau,real(totaln(ppa_lin,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa_lin,:)),'r:'); hold on;
end
if ppa_lin1~=0,
   [ppaMess, errmsg] = sprintf(' PPPA 2, target MSE = %g and alpha varying and leads to funct. = %g',tau,real(totaln(ppa_lin1,nbIter)));   
   Mess = strvcat(Mess ,  strcat(base,ppaMess));
   Pppa = plot(1:nbIter,real(totaln(ppa_lin1,:)),'r--'); hold on;
end
   
legend(Mess);


