function [line,col_ppa]=make_table_problem(PNumber,lambda,algos,acc)
%
  %    function [line,col_ppa]=make_table_problem(PNumber,lambda,algos,acc)
%
%   The line contains the smallest number of matrix-vector multiplication
%    such that for a given Problem Number and a given value for lambda,
%    the algorithms given in algos converge within a given accuracy.
%
%   in the result line : the order of the algorithm is
%        IT, PCD, GPSR, FPC, PPPA, l1ls, spgl1
%        The two first argument of line are the problem number and lambda
%
%   in the input algos : the order of the algorithms is
%        PCD , IT, l1ls, gpsr, fpc, pppa, spgl1
%
%   acc
%
%   col_ppa : column index of ppa algorithms
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LOAD RESULTS and INITIALISATION

[name, errmsg] = sprintf('result_%d_%g.mat',PNumber,lambda); 

load(name);

%%%%%%%%%%%%%%%%%%%%%%%%%%
% select ppa_alpha

index_alpha=1;
if ppa(1)~=0,
  index_alpha=1;
  funct_min=totaln(ppa(1),nbIter);
  for i=2:length(ppa),
	if funct_min>totaln(ppa(i),nbIter),
	    funct_min=totaln(ppa(i),nbIter);
            index_alpha=i;
        end;
  end;
end;
%%%%%%%%%%%%%%%%%%%%%%%%%%
% make the list of the algorithms

algoList = [];
if algos(2) ~= 0,   %IT
  algoList=[algoList it];
end;

if algos(1) ~= 0,   %PCD
  algoList=[algoList pcd];
end

if algos(4) ~= 0,   %GPSR
  algoList=[algoList gpsr_index];
end

if algos(5) ~= 0,   %FPC
  algoList=[algoList fpc_index];
end

if algos(6) ~= 0,   %PPPA
  algoList=[algoList ppa(index_alpha)];
  col_ppa(1) = length(algoList);
  algoList=[algoList ppa_lin];  
  col_ppa(2) = length(algoList);
end

if algos(3) ~= 0,   %L1_LS
  algoList=[algoList l1_ls_index];
end

if algos(7) ~= 0,   %SPGL1
  algoList=[algoList spgl1_index];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%
% select best convergence after 3000 iteration

best_end = algoList(1);
for i = 2:length(algoList),
    if totaln(algoList(i),nbIter) < totaln(best_end,nbIter),
	  best_end=algoList(i);
    end;
end;

%%%%%%%%%%%%%%%%%%%%%%%
% get best statistics

count=0;
target_stat = zeros(1,4);
for i = 1:length(algoList),
	  if totaln(algoList(i),nbIter) <= totaln(best_end,nbIter) *(1+acc(4)),
	      target_stat(1)=target_stat(1)+total0(algoList(i),nbIter);
	      target_stat(2)=target_stat(2)+total1(algoList(i),nbIter);
	      target_stat(3)=target_stat(3)+total2(algoList(i),nbIter);
              target_stat(4)=target_stat(4)+totaln(algoList(i),nbIter);
              count=count+1;
          end;
end;

target_stat=target_stat/count;

%target_stat = [total0(best_end,nbIter) total1(best_end,nbIter) total2(best_end,nbIter) totaln(best_end,nbIter) ];




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initialise line and index

line(1)= PNumber;
line(2)= lambda;
index = 3;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for i = 1:length(algoList),

  first_iter=nbIter+1;
  for j=2:nbIter,
	  if ( total0(algoList(i),j) <= target_stat(1) * (1+acc(1)) &&...
               total1(algoList(i),j) <= target_stat(2) * (1+acc(2)) &&...
               total2(algoList(i),j) <= target_stat(3) + acc(3) &&...
               totaln(algoList(i),j) <= target_stat(4) * (1+acc(4)) )
               
	       first_iter=j;
               break;
           end;
  end;
  line(index)=first_iter;
  index=index+1;  

end;
