function make_stat_table_problem(PNumber,lambda,algos,iter_disp)
%
%    function make_stat_table_problem(PNumber,lambda,algos,iter_disp)
%
%  creates a table displaying the statistics for a given problem 
%  and several algorithms.
%
%
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LOAD RESULTS and INITIALISATION

[name, errmsg] = sprintf('result_%d_%g.mat',PNumber,lambda); 

load(name);

%%%%%%%%%%%%%%%%%%%%%%%%%%
% select index for pppa_1

index_alpha=1;
if pppa_1(1)~=0,
  index_alpha=1;
  for i=2:length(pppa_1),
	if totaln(pppa_1(index_alpha),iter_disp) >totaln(pppa_1(i),iter_disp),
            index_alpha=i;
        end;
  end;
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%
% make the list of the algorithms

algoName = {};
algoList = [];
index=1;
if algos(2) ~= 0,   %IT
  algoList=[algoList it]; 
  algoName{index} = 'IT';
  index=index+1;
end;

if algos(1) ~= 0,   %PCD
  algoList=[algoList pcd];
  algoName{index} = 'PCD';
  index=index+1;
end;

if algos(4) ~= 0,   %GPSR
  algoList=[algoList gpsr_index];
  algoName{index} = 'GPSR-BB';
  index=index+1;
end;

if algos(5) ~= 0,   %FPC
  algoList=[algoList fpc_index];
  algoName{index} = 'FPC';
  index=index+1;
end;

if algos(6) ~= 0,   %PPPA
  algoList=[algoList pppa_1(index_alpha)];
  algoName{index} = 'PPPA 1';
  index=index+1;

  algoList=[algoList pppa_2];  
  algoName{index} = 'PPPA 2';
  index=index+1;

  algoList=[algoList pppa_3];  
  algoName{index} = 'PPPA 3';
  index=index+1;

end;

if algos(3) ~= 0,   %L1_LS
  algoList=[algoList l1_ls_index];
  algoName{index} = 'L1_LS';
  index=index+1;
end;

if algos(7) ~= 0,   %SPGL1
  algoList=[algoList spgl1_index];
  algoName{index} = 'SPGL1';
  index=index+1;
end;

%%%%%%%%%%%%%
% first line

stg='\begin{table}\begin{center}\begin{tabular}{|c|c|c|c|c|} \hline';

disp(stg);

%%%%%%%%%%%
% second line 
stg = ' algorithm & $l^0$ & $l^1$ & $RMSE$ & $f$ \\ \hline'; 
disp(stg);

%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%
for i = 1:length(algoList),

	  stg = algoName{i};
          tmp0 =   sprintf('& $%g$ & ',total0(algoList(i),iter_disp));
          tmp1 =   sprintf(' $%g$ & ',total1(algoList(i),iter_disp));
          tmp2 =   sprintf(' $%g$ & ',total2(algoList(i),iter_disp));
          tmpn =   sprintf(' $%g$ \\\\ \\hline ',totaln(algoList(i),iter_disp));

          stg = strcat(stg,tmp0);
          stg = strcat(stg,tmp1);
          stg = strcat(stg,tmp2);
          stg = strcat(stg,tmpn);

          disp(stg);
end;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% last line
stg = '\end{tabular}\end{center}';

disp(stg);
%%%%%%%%%%%%%%%%%%
% caption
stg= sprintf(' \\caption{$Problem = %g$, $\\lambda = %g$, target $RMSE = %g$, $time = %g$. PPPA 1 alpha=%g, PPPA 2 alpha=%g PPPA 3 alpha=%g} ',PNumber,lambda,tau,iter_disp,pppa_alpha(index_alpha),alpha_pppa(iter_disp),alpha_pppa1(iter_disp));
disp(stg);


%%%%%%%%%%%%%
% last line
stg = '\end{table}';

disp(stg);
