function make_pppa_table_problem(PNumber,lambda,iter_disp)
%
%    function make_pppa_table_problem(PNumber,lambda,iter_disp)
%
%  creates a table displaying the statistics for a given problem 
%  and a all the alphas.
%
%
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LOAD RESULTS and INITIALISATION

[name, errmsg] = sprintf('result_%d_%g.mat',PNumber,lambda); 

load(name);

%%%%%%%%%%%%%%%%%%%%%%%%%%

nbStat = 4;

%%%%%%%%%%%%%
% first line

stg='\begin{table}\begin{center}\begin{tabular}{|c|c|c|c|c|}\\hline';

disp(stg);

%%%%%%%%%%%
% second line 
stg = ' $\alpha$ & $l^0$ & $l^1$ & $l^2$ & func \\ \hline'; 
disp(stg);

%%%%%%%%%%%%%%%%%%%%%%%%%%
for i = 1:length(pppa_alpha),

	  stg = sprintf(' $%g$ & ',pppa_alpha(i));
          tmp0 =   sprintf(' $%g$ & ',total0(pppa_1(i),iter_disp));
          tmp1 =   sprintf(' $%g$ & ',total1(pppa_1(i),iter_disp));
          tmp2 =   sprintf(' $%g$ & ',total2(pppa_1(i),iter_disp));
          tmpn =   sprintf(' $%g$ \\\\ \\hline ',totaln(pppa_1(i),iter_disp));

          stg = strcat(stg,tmp0);
          stg = strcat(stg,tmp1);
          stg = strcat(stg,tmp2);
          stg = strcat(stg,tmpn);
 
          disp(stg);
end;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% last line
stg = '\end{tabular}\end{center}';

disp(stg);
%%%%%%%%%%%%%%%%%%
% caption
stg= sprintf(' \\caption{PPPA algorithm, $Problem = %g$, $\\lambda = %g$, $target_MSE = %g$, $iter = %g$} ',PNumber,lambda,tau,iter_disp);
disp(stg);


%%%%%%%%%%%%%
% last line
stg = '\end{table}';

disp(stg);
