function [Out] = TILDCT_transp(In,n,d)
%    [Out] = TILDCT_transp(In,n,d)
%
% Decomposes an image In into a frame of Translation Invariant Local
% Discrete Cosine Dictionary. (multiplication by A') 
% In : input image (must be square)
% Out : decomposition of the image

%'

d= length(In(:));
sz=sqrt(d);
In = reshape(In,[sz,sz]);
In = [In In(:,1:7)];
In = [In ; In(1:7,:)];

In = im2col(In,[8,8], 'sliding');
T=kron(dctmtx(8),dctmtx(8)); 
Out = T*In;

Out=Out(:);

return;

