function [Out] = TILDCT_direct(In)
%    [Out] = TILDCT_direct(In)
%
% Reconstruct a set of coordinates by a 2D translation invariant local 
% discrete cosine frame. (Multiplication by A)
% 
% In : input coordinates (its size must be square)
% Out : reconstructed image

n=length(In);
sz = sqrt(n/64);  
               
In = reshape(In,[64,n/64]);
tt = inv(dctmtx(8));
T = kron(tt,tt); 
In = T*In; 
Out = zeros(sz+8,sz+8); 

counter=1; 
for j=1:1:8, 
    for k=1:1:8,
        Out(k:sz+k-1,j:sz+j-1) = Out(k:sz+k-1,j:sz+j-1)+ ...
               	reshape(In(counter,:),sz,sz);               
        counter = counter+1;
    end;
end;

Out_center=Out(1:sz,1:sz);
Out_right=Out(1:sz,sz+1:sz+8);
Out_bottom=Out(sz+1:sz+8,1:sz);
Out_corner=Out(sz+1:sz+8,sz+1:sz+8);

Out_right=[Out_right(1:8,:)+Out_corner; Out_right(9:sz,:)];
Out_center=[Out_right+Out_center(1:sz,1:8) Out_center(1:sz,9:sz)];
Out_center=[Out_bottom+Out_center(1:8,:); Out_center(9:sz,:)];

Out=Out_center(:);

return;

