function [ x_trans_tau ] = translation( x,tau )
%   function [ x_trans_tau ] = translation( x,tau )
%
% 2D Translation of sparse table x and translation vector tau
%   input x CAN be passed as SPARSE type
%
% Author Olivier Chabiron
%

[s1,s2] = size(x) ;

% Find non-zero entries
[xrow, xcol, xval] = find(x) ;
rx = xrow ; cx = xcol ;
rf = tau(1) ; cf = tau(2) ;

% Compute translated indexes n1,n2
n1 = rf+rx-1 ; n2 = cf+cx-1 ; % n = (n-m)+m
n1 = (n1<=s1).*n1 + (n1>s1).*(n1-s1) ; % N+k = k
n2 = (n2<=s2).*n2 + (n2>s2).*(n2-s2) ;

x_trans_tau = sparse(n1,n2,xval,s1,s2) ;


end

