function [ result ] = structconv2( hk_struct,nums,mode )
%
%   function [ result ] = structconv2( hk_struct,nums,mode )
%
%   Convolves the requiered kernels in HK_STRUCT designated by the indexes
%   in NUMS. MODE is 'normal' by default but can be changed to 'noCoord' 
%   to avoid convoluting the resulting atom with the code.
%
% Author Olivier Chabiron
%

if nargin <3
    mode = 'normal' ;
end

N = hk_struct.Size(1) ; M = hk_struct.Size(2) ;
result = [1 zeros(1,M-1) ; zeros(N-1,M)] ; % dirac delta function

if strcmp(mode,'normal')
    for i=1:length(nums)
        k = nums(i) ;
        result = sparseconv2(result,hk_struct.filters(k).h) ;
    end
    
    % Convolution with the code
    result = sparseconv2(result,hk_struct.Coord) ;
    
elseif strcmp(mode,'noCoord')
    for i=1:length(nums)
        k = nums(i) ;
        result = sparseconv2(result,hk_struct.filters(k).h) ;
    end

end


