function [ xconvf ] = sparseconv2( x,f )
%
%    function [ xconvf ] = sparseconv2( x,f)
%
% 2D Convolution of sparse tables x and f
%   Both inputs x and f CAN be passed as SPARSE type
%   Output xconvf will be of size(x)
%
% Author Olivier Chabiron
%

[s1,s2] = size(x) ;

% Find non-zero entries
[xrow, xcol, xval] = find(x) ;
num_NZ_x = length(xval) ;

[frow, fcol, fval] = find(f) ;
num_NZ_f = length(fval) ;

% Compute convolution
xconvf = zeros(s1,s2) ; % x sets the output image size

for jx=1:num_NZ_x % Small loop if x is sparse
    rx = xrow(jx) ; cx = xcol(jx) ;
    
    for jf=1:num_NZ_f % Small loop if f is sparse
        rf = frow(jf) ; cf = fcol(jf) ;
        
        % Compute index n1,n2
        n1 = rf+rx-1 ; n2 = cf+cx-1 ; % n = (n-m)+m
        n1 = (n1<=s1)*n1 + (n1>s1)*(n1-s1) ; % N+k = k
        n2 = (n2<=s2)*n2 + (n2>s2)*(n2-s2) ; 
        
        % Sum the terms
        xconvf(n1,n2) = xconvf(n1,n2) + fval(jf)*xval(jx) ;
    end
end

end

