function [  ] = print_demo( hk_struct,H,u )
%   print_demo( hk_struct,H )
%
%   Prints figures showing the code, the comparison between the atom and
%   its approximation vy the composition of convolutions, and the kernels.
%
% Author Olivier Chabiron
%

K = hk_struct.K ;
atomapprox = hk_struct.Lambda*structconv2(hk_struct,1:K,'noCoord') ;
imgapprox = hk_struct.Lambda*structconv2(hk_struct,1:K,'normal') ;
S = numel(find(hk_struct.filters(1).Sh)) ;

figure ; % ALPHA
colormap gray ; title('Code image') ;
imagesc(hk_struct.Coord) ; xlabel('Input code image') ;

figure ; % COMPARE TO TRUE ATOM 
colormap gray ; 
subplot(1,2,1) ; imagesc(atomapprox) ;
info = strcat('Atom estimation (','K=',num2str(K),', S=',num2str(S),')') ;
axis square ; xlabel(info) ;
subplot(1,2,2) ; imagesc(H) ;
axis square ; xlabel('Unknown target atom') ;

figure ; % COMPARE TO TRUE SIGNAL/IMAGE
colormap gray ; 
subplot(1,2,1) ; imagesc(imgapprox) ;
info = strcat('Data approximation (','K=',num2str(K),', S=',num2str(S),')') ;
axis square ; xlabel(info) ;
subplot(1,2,2) ; imagesc(u) ;
axis square ; xlabel('Input data') ;

figure ; % KERNELS
colormap gray ; 
nbCol = ceil(sqrt(hk_struct.K)) ;
nbLig = ceil(hk_struct.K/nbCol) ;
for k1=1:nbCol %
    for k2=1:nbLig
        K = (k2-1)*nbCol + k1 ;
        if K<=hk_struct.K,
            subplot(nbLig,nbCol,K) ;
            name = strcat('kernel h_{',int2str(K),'}') ;
            % center and zoom on kernel
            t = ceil( hk_struct.Size/2 ) ;
            tmp = translation(hk_struct.filters(K).h,t) ;
            sqSize = ceil( sqrt( sum(tmp(:)~=0) )/2 ) *ceil(K/2)*2+1 ;
            imagesc(tmp(t(1)-sqSize:t(1)+sqSize,t(2)-sqSize:t(2)+sqSize),[-1 1]) ;
            axis square ; xlabel(name) ;
        end;
    end;
end

end

