function [out, func, constr] = dequantifieImage(in, lambda, quantif_step, nbIter)
 %   
 %  function [out, func, constr] = dequantifieImage(in, lambda, quantif_step, nbIter)
 %   
 %  dequantifie une image "in" pour un pas de quantification "quantif_step". 
 %  Pour cela, on minimise pendant "nbIter" iterations de gradient
 %   
 %  \sum |\nabla w|^2 + lambda \| phi(|w - in |)\|, où phi pénalise |w-in|>quantif_step/2 
 %
 % Les résultats sont :
 %      "out" : l'image résultat
 %      "func": la fonctionnelle au cours des itérations
 %      "constr" : la norme de ce qui sort des contraintes
 %
 
 
%out = 128*ones(size(in));
out = in;

for iter = 1:nbIter
	descente = moins_gradient(in,lambda,quantif_step,out);
%	figure ; imageplot(descente);
%	draw_func(in,lambda,quantif_step,out,descente);
	[step, func(iter)] = armijo_step(in,lambda,quantif_step,out,descente);
	out = out + step * descente;
    	tmp = abs(out-in)-0.5*quantif_step ;
	constr(iter) = max(max( tmp .* (tmp>0) ));	

	fprintf('iteration %-5d,      step %-10g,       functional value %-10g,      error on constraints %-10g\n',iter,step,func(iter),constr(iter));
end

  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function descente = moins_gradient(in,lambda,quantif_step,out)

	tmp = grad_x(out,0);
	lap_x= grad_x(tmp,1);
	tmp = grad_y(out,0);
	lap_y= grad_y(tmp,1);

	tmp1 = out-in-0.5*quantif_step;
	tmp2 = in-out-0.5*quantif_step;
	grad = 2*lap_x +2* lap_y + 2 * lambda* ( (tmp1 .* (tmp1>0)) - (tmp2 .* (tmp2>0)) );
	descente = - grad;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function f = feval(step,in,lambda,quantif_step,out,descente)
    	out_tmp = out+step*descente;
    	Dx = grad_x(out_tmp,0);
    	Dy = grad_y(out_tmp,0);
    
	tmp = abs(out_tmp-in)-0.5*quantif_step;
	tmp1 = tmp .* (tmp>0);
    	f = sum(sum(Dx.*Dx)) + sum(sum(Dy.*Dy)) + lambda * sum(sum( tmp1.*tmp1 ));
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function draw_func(in,lambda,quantif_step,out,descente)
	stepi=-1:0.1:1;
	stepi = stepi*0.01;
	for i=1:length(stepi)
		fi(i)=feval(stepi(i),in,lambda,quantif_step,out,descente);
	end;
	plot(stepi,fi,'b-');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function  [stepi, fi] = armijo_step(in,lambda,quantif_step,out,descente)
    	beta=0.5; 
    	sigma=0.5; 
    	kmax=50;
    	stepi=1;
    
    	norm_descente = - sum(sum(descente.*descente));
	f0= feval(0,in,lambda,quantif_step,out,descente);
	fi=feval(stepi,in,lambda,quantif_step,out,descente);
	k=0;
	while (fi > f0+sigma*stepi*norm_descente) & (k<kmax)
	  	k=k+1;
	  	stepi=beta*stepi;
	  	fi=feval(stepi,in,lambda,quantif_step,out,descente);
	end
	
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function out = grad_x(in,adjoint)

[sx,sy]=size(in);

if adjoint == 0
	tmp = [in(2:sx,:) ; in(1,:)];
	out = tmp - in;
else
	tmp = [ in(sx,:) ; in(1:sx-1,:) ];
	out = tmp - in;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function out = grad_y(in,adjoint)

[sx,sy]=size(in);

if adjoint == 0
	tmp = [in(:,2:sy) , in(:,1)];
	out = tmp - in;
else
	tmp = [ in(:,sy) , in(:,1:sy-1) ];
	out = tmp - in;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 
 
